'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_ChartVennDiagram32 = {
  name: 'ChartVennDiagram32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M20 6a9.92 9.92 0 0 0-4 .84A9.92 9.92 0 0 0 12 6a10 10 0 0 0 0 20 9.92 9.92 0 0 0 4-.84 9.92 9.92 0 0 0 4 .84 10 10 0 0 0 0-20zm-8 18a8 8 0 0 1 0-16 7.91 7.91 0 0 1 1.76.2 10 10 0 0 0 0 15.6A7.91 7.91 0 0 1 12 24zm8-8a8 8 0 0 1-4 6.92 8 8 0 0 1 0-13.84A8 8 0 0 1 20 16zm0 8a7.91 7.91 0 0 1-1.76-.2 10 10 0 0 0 0-15.6A7.91 7.91 0 0 1 20 8a8 8 0 0 1 0 16z"
      }
    }), children]);
  }
};

module.exports = virtual_ChartVennDiagram32;
