'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Cut20 = {
  name: 'Cut20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M26.5 19.63L20.24 16l6.26-3.63a5 5 0 0 0-1.21-9.2A5.19 5.19 0 0 0 24 3a5 5 0 0 0-4.33 7.53 5 5 0 0 0 2.39 2.1l-3.82 2.21L4 6.6 3 8.34 16.24 16 3 23.68l1 1.74 14.24-8.26 3.82 2.21a5 5 0 0 0-2.39 2.1A5 5 0 0 0 24 29a5.19 5.19 0 0 0 1.29-.17 5 5 0 0 0 1.21-9.2zm-5.1-10.1a3 3 0 0 1 1.1-4.12 3 3 0 0 1 4.1 1.11 3 3 0 0 1-1.1 4.11 3 3 0 0 1-4.1-1.1zm5.2 16a3 3 0 0 1-4.1 1.11 3 3 0 0 1-1.1-4.12 3 3 0 0 1 4.1-1.1 3 3 0 0 1 1.1 4.06z"
      }
    }), children]);
  }
};

module.exports = virtual_Cut20;
