'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_DataSet20 = {
  name: 'DataSet20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M25 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zM8.5 6A3.5 3.5 0 1 1 5 9.5 3.5 3.5 0 0 1 8.5 6m0-2A5.5 5.5 0 1 0 14 9.5 5.5 5.5 0 0 0 8.5 4zm0 16A3.5 3.5 0 1 1 5 23.5 3.5 3.5 0 0 1 8.5 20m0-2a5.5 5.5 0 1 0 5.5 5.5A5.5 5.5 0 0 0 8.5 18zm15 2a3.5 3.5 0 1 1-3.5 3.5 3.5 3.5 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5z"
      }
    }), children]);
  }
};

module.exports = virtual_DataSet20;
