'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_EarthAmericasFilled32 = {
  name: 'EarthAmericasFilled32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M16 2a14 14 0 1 0 14 14A14.016 14.016 0 0 0 16 2zM4 16a11.915 11.915 0 0 1 .7-4H10l5 4-2.8 3.693A1 1 0 0 0 12.293 21L15 24v3.95A12.01 12.01 0 0 1 4 16zm17.435 10.685l2.546-7.7a1 1 0 0 0-.367-.985L15 11l2-2h5.28a1 1 0 0 0 .948-.684l.495-1.486a11.974 11.974 0 0 1-2.288 19.855z"
      }
    }), children]);
  }
};

module.exports = virtual_EarthAmericasFilled32;
