'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_EarthEuropeAfricaFilled16 = {
  name: 'EarthEuropeAfricaFilled16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M16 2a14 14 0 1 0 14 14A14.016 14.016 0 0 0 16 2zM4 16a11.981 11.981 0 0 1 5-9.727V9a1 1 0 0 0 1 1h3.382a1 1 0 0 0 .894-.553L15 8h4v6h-5.764a1 1 0 0 0-.447.105l-3.236 1.619a1 1 0 0 0-.553.894v3.705a1 1 0 0 0 .629.929L14 23l.824 4.94A12.015 12.015 0 0 1 4 16zm18 10.376V23l1.755-2.632a1.001 1.001 0 0 0 .138-.797L23 16v-3h4.605A11.901 11.901 0 0 1 22 26.376z"
      }
    }), children]);
  }
};

module.exports = virtual_EarthEuropeAfricaFilled16;
