'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_EarthEuropeAfrica20 = {
  name: 'EarthEuropeAfrica20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M16 2a14 14 0 1 0 14 14A14.016 14.016 0 0 0 16 2zM4 16a11.96 11.96 0 0 1 4-8.919V9a2 2 0 0 0 2 2h3.382a2 2 0 0 0 1.79-1.106L15.617 9H18v4h-4.765a2 2 0 0 0-.893.21l-3.237 1.62A2 2 0 0 0 8 16.617v3.705a2 2 0 0 0 1.257 1.857l3.849 1.54.678 4.066A12.014 12.014 0 0 1 4 16zm11.846 11.992l-.952-5.712L10 20.323v-3.705L13.236 15H20V7h-5.618l-1 2H10V5.623A11.958 11.958 0 0 1 27.3 12H22v4l.922 3.813L21 22.698v4.197A11.908 11.908 0 0 1 16 28c-.052 0-.102-.007-.154-.008zM23 25.727v-2.424l1.586-2.38a2.003 2.003 0 0 0 .277-1.595L24 15.877V14h3.82A11.84 11.84 0 0 1 23 25.727z"
      }
    }), children]);
  }
};

module.exports = virtual_EarthEuropeAfrica20;
