'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_EarthSoutheastAsiaFilled32 = {
  name: 'EarthSoutheastAsiaFilled32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M17 22h2v2h-2zm0-4h2v2h-2zm-3 6h3v2h-3z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M16 2a14 14 0 1 0 14 14A14.016 14.016 0 0 0 16 2zM4.7 20H6l4.177 2.6a1 1 0 0 0 1.36-.294l1.008-1.512a1 1 0 0 0-.125-1.261L10 17.112 11 14h5.323a1 1 0 0 0 .928-.628l1.582-3.955a1 1 0 0 0-.034-.819l-2.286-4.572A11.965 11.965 0 0 1 26.376 22H23a1 1 0 0 0-1 1v3.377A11.958 11.958 0 0 1 4.7 20z"
      }
    }), children]);
  }
};

module.exports = virtual_EarthSoutheastAsiaFilled32;
