'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Enterprise16 = {
  name: 'Enterprise16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M28 28V14a2 2 0 0 0-2-2h-4V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v24H2v2h28v-2zM6 4h14v24H6zm16 24V14h4v14z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M10 8h2v4h-2zm0 6h2v4h-2zm4-6h2v4h-2zm0 6h2v4h-2zm-4 6h2v4h-2zm4 0h2v4h-2z"
      }
    }), children]);
  }
};

module.exports = virtual_Enterprise16;
