'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_FaceActivatedAdd32 = {
  name: 'FaceActivatedAdd32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM9 20a8.13 8.13 0 0 0 14 0z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M27.82 14A12 12 0 1 1 16 4V2a14 14 0 1 0 14 14 14.71 14.71 0 0 0-.16-2z"
      }
    }), children]);
  }
};

module.exports = virtual_FaceActivatedAdd32;
