'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Favorite16 = {
  name: 'Favorite16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M11.2 3c.7 0 1.4.3 2 .8 1.1 1.1 1.1 2.9 0 4L8 13.1 2.8 7.8c-1.1-1.1-1.1-2.9 0-4s2.8-1.1 3.9 0L8 5.1l1.3-1.3c.5-.5 1.2-.8 1.9-.8m0-1c-1 0-2 .4-2.7 1.1l-.5.6-.6-.6C6 1.6 3.6 1.6 2.1 3.1S.6 7 2.1 8.5l5.9 6 5.9-6c1.5-1.5 1.5-3.9 0-5.4-.7-.7-1.7-1.1-2.7-1.1z"
      }
    }), children]);
  }
};

module.exports = virtual_Favorite16;
