'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_FolderAdd16 = {
  name: 'FolderAdd16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M13 10h-1v2h-2v1h2v2h1v-2h2v-1h-2z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M14 4H8L6.3 2.3c-.2-.2-.4-.3-.7-.3H2c-.6 0-1 .4-1 1v10c0 .6.4 1 1 1h6v-1H2V3h3.6l1.7 1.7.3.3H14v4h1V5c0-.6-.4-1-1-1z"
      }
    }), children]);
  }
};

module.exports = virtual_FolderAdd16;
