'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Help16 = {
  name: 'Help16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 13c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"
      }
    }), createElement('circle', {
      attrs: {
        "cx": "8",
        "cy": "11.8",
        "r": ".8"
      }
    }), createElement('path', {
      attrs: {
        "d": "M8.5 4h-.7C6.5 4 5.5 5 5.5 6.2v.2h1v-.2c0-.6.6-1.2 1.3-1.2h.8c.7 0 1.2.6 1.2 1.2s-.6 1.3-1.3 1.3h-1v2.2h1V8.5c1.2 0 2.2-1 2.2-2.2S9.7 4 8.5 4z"
      }
    }), children]);
  }
};

module.exports = virtual_Help16;
