'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Hotel20 = {
  name: 'Hotel20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M9.5 15A1.5 1.5 0 1 1 8 16.5 1.5 1.5 0 0 1 9.5 15m0-2a3.5 3.5 0 1 0 3.5 3.5A3.5 3.5 0 0 0 9.5 13z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M25 14h-8a2 2 0 0 0-2 2v6H4V10.6l12-6.46 12.53 6.74.94-1.76-13-7a1 1 0 0 0-.94 0l-13 7A1 1 0 0 0 2 10v20h2v-6h24v6h2V19a5 5 0 0 0-5-5zm-8 8v-6h8a3 3 0 0 1 3 3v3z"
      }
    }), children]);
  }
};

module.exports = virtual_Hotel20;
