'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_LetterYy16 = {
  name: 'LetterYy16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M15 9h-2l-2 7-2-7H7l3 9v5h2v-5l3-9zm8 4l-2 7.52L19.08 13H17l3.15 9.87-.62 2.13H17v2h2.26a2 2 0 0 0 1.91-1.42L25 13z"
      }
    }), children]);
  }
};

module.exports = virtual_LetterYy16;
