'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_LogoDigg16 = {
  name: 'LogoDigg16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M6.48 7.6v3.92H2V21h7.28V7.6zm0 11.2H4.8v-5h1.68zm3.92-7.28h2.8v9.52h-2.8zm0-3.92h2.8v2.8h-2.8zm3.92 3.92V21h4.48v1.12h-4.48v2.28h7.28V11.52zm4.48 7.28h-1.68v-5h1.68zm3.92-7.28V21h4.48v1.12h-4.48v2.28H30V11.52zm4.48 7.28h-1.68v-5h1.68z"
      }
    }), children]);
  }
};

module.exports = virtual_LogoDigg16;
