'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_LogoQuora24 = {
  name: 'LogoQuora24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M29 23.86h-2a1.72 1.72 0 0 1-1.73 1.72c-1.15 0-1.82-.86-2.58-2a11 11 0 0 0 4.79-9.1c.09-7.19-5.85-11.89-12.17-11.89S3 7.37 3 14.37s6 11.79 12.17 11.79a10.71 10.71 0 0 0 3.07-.48c1.15 2.11 2.59 3.74 5.46 3.74a5 5 0 0 0 5.3-5.56zm-8.14-3.45a6.31 6.31 0 0 0-5.56-3.16 6 6 0 0 0-3.74 1.15l.64 1.6a2.56 2.56 0 0 1 .86-.1c1.82 0 3 1.53 4.12 3.64a7.58 7.58 0 0 1-1.91.19C10.86 23.76 9 20.6 9 14.47s1.91-9.3 6.23-9.3 6.32 3.16 6.32 9.3a20.68 20.68 0 0 1-.72 5.94z"
      }
    }), children]);
  }
};

module.exports = virtual_LogoQuora24;
