'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_LogoSkype24 = {
  name: 'LogoSkype24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M27.91 17.88a11.63 11.63 0 0 0 .15-1.88A12.06 12.06 0 0 0 16 3.94a11.63 11.63 0 0 0-1.88.15 7.29 7.29 0 0 0-10 10A11.63 11.63 0 0 0 3.94 16 12.06 12.06 0 0 0 16 28.06a11.63 11.63 0 0 0 1.88-.15 7.29 7.29 0 0 0 10-10zm-6.18 3.6a5 5 0 0 1-2.24 1.73 9 9 0 0 1-3.48.62A8.41 8.41 0 0 1 12 23a5.2 5.2 0 0 1-1.82-1.63 3.59 3.59 0 0 1-.7-2 1.36 1.36 0 0 1 .43-1A1.56 1.56 0 0 1 11 18a1.38 1.38 0 0 1 .91.32 2.5 2.5 0 0 1 .63.94 5.83 5.83 0 0 0 .66 1.18 2.61 2.61 0 0 0 1 .78 3.87 3.87 0 0 0 1.69.31 4 4 0 0 0 2.34-.62 1.8 1.8 0 0 0 .89-1.53 1.54 1.54 0 0 0-.47-1.17 3.09 3.09 0 0 0-1.25-.7c-.52-.17-1.21-.34-2.08-.53a16 16 0 0 1-2.91-.98 4.78 4.78 0 0 1-1.89-1.4 3.5 3.5 0 0 1-.7-2.21 3.65 3.65 0 0 1 .74-2.24 4.7 4.7 0 0 1 2.14-1.5 9.51 9.51 0 0 1 3.3-.48 8.63 8.63 0 0 1 2.59.35 5.81 5.81 0 0 1 1.83.92 3.91 3.91 0 0 1 1.06 1.21 2.62 2.62 0 0 1 .34 1.25 1.4 1.4 0 0 1-.43 1 1.43 1.43 0 0 1-1.07.46 1.25 1.25 0 0 1-.89-.28 3.36 3.36 0 0 1-.65-.87 3.79 3.79 0 0 0-1.05-1.31 3.13 3.13 0 0 0-1.95-.46 3.64 3.64 0 0 0-2 .5 1.44 1.44 0 0 0-.76 1.2 1.15 1.15 0 0 0 .25.75 2.21 2.21 0 0 0 .72.55 4.74 4.74 0 0 0 .92.36c.32.09.84.22 1.57.39.92.2 1.74.42 2.49.66a7.61 7.61 0 0 1 1.9.88 3.59 3.59 0 0 1 1.23 1.31 4 4 0 0 1 .4 1.96 4.24 4.24 0 0 1-.77 2.48z"
      }
    }), children]);
  }
};

module.exports = virtual_LogoSkype24;
