'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_MacShift24 = {
  name: 'MacShift24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M21 28H11a2 2 0 0 1-2-2V16H4a1 1 0 0 1-.92-.62 1 1 0 0 1 .21-1.09l12-12a1 1 0 0 1 1.42 0l12 12a1 1 0 0 1 .21 1.09A1 1 0 0 1 28 16h-5v10a2 2 0 0 1-2 2zM6.41 14H10a1 1 0 0 1 1 1v11h10V15a1 1 0 0 1 1-1h3.59L16 4.41z"
      }
    }), children]);
  }
};

module.exports = virtual_MacShift24;
