'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Misuse24 = {
  name: 'Misuse24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 24 24',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M12 1C6 1 1 6 1 12s5 11 11 11 11-4.9 11-11S18.1 1 12 1zm4.2 16.5L12 13.3l-4.2 4.2-1.3-1.3 4.2-4.2-4.2-4.2 1.3-1.3 4.2 4.2 4.2-4.2 1.3 1.3-4.2 4.2 4.2 4.2-1.3 1.3z"
      }
    }), createElement('path', {
      attrs: {
        "fill": "none",
        "d": "M16.2 17.5L12 13.3l-4.2 4.2-1.3-1.3 4.2-4.2-4.2-4.2 1.3-1.3 4.2 4.2 4.2-4.2 1.3 1.3-4.2 4.2 4.2 4.2-1.3 1.3z",
        "data-icon-path": "inner-path",
        "opacity": "0"
      }
    }), children]);
  }
};

module.exports = virtual_Misuse24;
