'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Network_232 = {
  name: 'Network_232',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M17 17h5.142a4 4 0 1 0 0-2H17V7h5.142a4 4 0 1 0 0-2H17a2.002 2.002 0 0 0-2 2v8H9.858a4 4 0 1 0 0 2H15v8a2.002 2.002 0 0 0 2 2h5.142a4 4 0 1 0 0-2H17zm9-3a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 18a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 6a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2z"
      }
    }), children]);
  }
};

module.exports = virtual_Network_232;
