'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_PartlyCloudy16 = {
  name: 'PartlyCloudy16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M21.743 18.692a6.05 6.05 0 0 0 1.057-1.086 5.998 5.998 0 1 0-10.733-4.445 7.557 7.557 0 0 0-5.716 5.088A5.993 5.993 0 0 0 8 30.005h11a5.985 5.985 0 0 0 2.743-11.313zM18 10.005a4.004 4.004 0 0 1 4 4 3.961 3.961 0 0 1-.8 2.4 4.012 4.012 0 0 1-.94.891 7.542 7.542 0 0 0-6.134-4.24A3.998 3.998 0 0 1 18 10.005zm1 18H8a3.993 3.993 0 0 1-.673-7.93l.663-.112.146-.656a5.496 5.496 0 0 1 10.729 0l.146.656.662.112a3.993 3.993 0 0 1-.673 7.93zm7-15h4v2h-4zM22.95 7.64l2.828-2.827 1.415 1.414-2.829 2.828zM17 2.005h2v4h-2zM8.808 6.227l1.414-1.414 2.829 2.828-1.415 1.414z"
      }
    }), children]);
  }
};

module.exports = virtual_PartlyCloudy16;
