'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_PersonFavorite16 = {
  name: 'PersonFavorite16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M10 31H6a2.006 2.006 0 0 1-2-2v-7a2.006 2.006 0 0 1-2-2v-6a2.946 2.946 0 0 1 3-3h6a2.946 2.946 0 0 1 3 3v6a2.006 2.006 0 0 1-2 2v7a2.006 2.006 0 0 1-2 2zM5 13a.945.945 0 0 0-1 1v6h2v9h4v-9h2v-6a.945.945 0 0 0-1-1zm3-3a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm20.766.256A4.212 4.212 0 0 0 23 4.032a4.212 4.212 0 0 0-5.766.224 4.319 4.319 0 0 0 0 6.044l5.764 5.84.002-.002.002.001 5.764-5.839a4.319 4.319 0 0 0 0-6.044zm-1.424 4.639l-4.34 4.397L23 13.29l-.002.002-4.34-4.397a2.308 2.308 0 0 1 0-3.234 2.264 2.264 0 0 1 3.156 0l1.181 1.207.005-.005.005.005 1.18-1.207a2.264 2.264 0 0 1 3.157 0 2.308 2.308 0 0 1 0 3.234z"
      }
    }), children]);
  }
};

module.exports = virtual_PersonFavorite16;
