'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_RestaurantFine32 = {
  name: 'RestaurantFine32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M30 11V3a1 1 0 0 0-1-1H19a1 1 0 0 0-1 1v8a6.004 6.004 0 0 0 5 5.91V28h-4v2h10v-2h-4V16.91A6.004 6.004 0 0 0 30 11zm-10 0V4h8v7a4 4 0 1 1-8 0zm-8-9v9.02a3.964 3.964 0 0 1-3.96 3.96A4.005 4.005 0 0 1 4 11.02V2H2v9.02a5.989 5.989 0 0 0 5 5.865V30h2V16.895a5.965 5.965 0 0 0 5-5.875V2z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M7 2h2v9.98H7z"
      }
    }), children]);
  }
};

module.exports = virtual_RestaurantFine32;
