'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Scalpel24 = {
  name: 'Scalpel24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M28.83 5.17a4.1 4.1 0 0 0-5.66 0L.34 28h9.25a5 5 0 0 0 3.53-1.46l15.71-15.71a4 4 0 0 0 0-5.66zM12.29 18.88l2.09-2.09 2.83 2.83-2.09 2.09zm-.58 6.24a3 3 0 0 1-2.12.88H5.17l5.71-5.71 2.83 2.83zm15.7-15.71l-8.79 8.8-2.83-2.83 8.8-8.79a2 2 0 0 1 2.82 0 2 2 0 0 1 0 2.82z"
      }
    }), children]);
  }
};

module.exports = virtual_Scalpel24;
