'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_TextTracking16 = {
  name: 'TextTracking16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M25.29 19.29l-1.41 1.42L26.17 23H5.83l2.29-2.29-1.41-1.42L2 24l4.71 4.71 1.41-1.42L5.83 25h20.34l-2.29 2.29 1.41 1.42L30 24l-4.71-4.71zM26 17h2L23 3h-2l-5 14h2l1-3h6zm-6.33-5L22 5l2.33 7zM14 3l-4 12L6 3H4l5 14h2l5-14h-2z"
      }
    }), children]);
  }
};

module.exports = virtual_TextTracking16;
