'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Touch_224 = {
  name: 'Touch_224',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M29 15h-2a11 11 0 0 0-22 0H3a13 13 0 0 1 26 0z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M25 28h-2V15a7 7 0 1 0-14 0v13H7V15a9 9 0 0 1 18 0z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M21 20H11v-5a5 5 0 0 1 10 0zm-8-2h6v-3a3 3 0 0 0-6 0z"
      }
    }), children]);
  }
};

module.exports = virtual_Touch_224;
