'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_UnknownFilled24 = {
  name: 'UnknownFilled24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M29.416 14.59L17.41 2.585a1.994 1.994 0 0 0-2.82 0L2.585 14.591a1.994 1.994 0 0 0 0 2.819L14.59 29.416a1.994 1.994 0 0 0 2.819 0L29.416 17.41a1.994 1.994 0 0 0 0-2.82zM16 24a1.5 1.5 0 1 1 1.5-1.5A1.5 1.5 0 0 1 16 24zm1.125-6.752v1.877h-2.25V15H17a1.875 1.875 0 0 0 0-3.75h-2a1.877 1.877 0 0 0-1.875 1.875v.5h-2.25v-.5A4.13 4.13 0 0 1 15 9h2a4.125 4.125 0 0 1 .125 8.248z"
      }
    }), createElement('path', {
      attrs: {
        "fill": "none",
        "d": "M16 21a1.5 1.5 0 1 1-1.5 1.5A1.5 1.5 0 0 1 16 21zm1.125-3.752A4.125 4.125 0 0 0 17 9h-2a4.13 4.13 0 0 0-4.125 4.125v.5h2.25v-.5A1.877 1.877 0 0 1 15 11.25h2A1.875 1.875 0 0 1 17 15h-2.125v4.125h2.25z",
        "data-icon-path": "inner-path"
      }
    }), children]);
  }
};

module.exports = virtual_UnknownFilled24;
