'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Van16 = {
  name: 'Van16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M29.81 16l-7-9.56A1 1 0 0 0 22 6H3a1 1 0 0 0-1 1v17a1 1 0 0 0 1 1h2.14a4 4 0 0 0 7.72 0h6.28a4 4 0 0 0 7.72 0H29a1 1 0 0 0 1-1v-7.44a1 1 0 0 0-.19-.56zM20 8h1.49l5.13 7H20zM9 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14 0a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm5-3h-1.14a4 4 0 0 0-7.72 0h-6.28a4 4 0 0 0-7.72 0H4V8h14v9h10z"
      }
    }), children]);
  }
};

module.exports = virtual_Van16;
