'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_View16 = {
  name: 'View16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M15.5 7.8C14.3 4.7 11.3 2.6 8 2.5 4.7 2.6 1.7 4.7.5 7.8v.3c1.2 3.1 4.1 5.2 7.5 5.3 3.3-.1 6.3-2.2 7.5-5.3v-.3zM8 12.5c-2.7 0-5.4-2-6.5-4.5 1-2.5 3.8-4.5 6.5-4.5s5.4 2 6.5 4.5c-1.1 2.5-3.9 4.5-6.5 4.5z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M8 5C6.3 5 5 6.3 5 8s1.3 3 3 3 3-1.3 3-3-1.3-3-3-3zm0 5c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"
      }
    }), children]);
  }
};

module.exports = virtual_View16;
