'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthAngle32 = {
  name: 'WatsonHealthAngle32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M9 24a3.51 3.51 0 0 0-.88-1.86l9.53-16.58-1.73-1-9.57 16.56A3.06 3.06 0 0 0 5.5 21a3.5 3.5 0 1 0 3.15 5H28v-2zm-3.5 2A1.5 1.5 0 1 1 7 24.5 1.5 1.5 0 0 1 5.5 26z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M22 21h2a13 13 0 0 0-5.42-10.56l-1.16 1.62A11 11 0 0 1 22 21z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthAngle32;
