'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthAnnotationVisibility32 = {
  name: 'WatsonHealthAnnotationVisibility32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H4V6h24z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M21 20h-8a3.51 3.51 0 0 0-.88-1.86l3.8-6.64-1.74-1-3.78 6.62a3.35 3.35 0 0 0-.9-.12 3.5 3.5 0 1 0 3.15 5H21zM9.5 22a1.5 1.5 0 1 1 1.5-1.5A1.5 1.5 0 0 1 9.5 22zM19 8h7v2h-7zm0 4h4v2h-4z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthAnnotationVisibility32;
