'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthCdCreateArchive32 = {
  name: 'WatsonHealthCdCreateArchive32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M14 20a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z"
      }
    }), createElement('circle', {
      attrs: {
        "cx": "14",
        "cy": "14",
        "r": "2"
      }
    }), createElement('path', {
      attrs: {
        "d": "M17 23.54A10 10 0 1 1 24 14c0 .34 0 .67-.05 1h2c0-.33.05-.66.05-1a12 12 0 1 0-12 12 12.33 12.33 0 0 0 3-.39z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M25 30l-2.14-1A5 5 0 0 1 20 24.47V18h10v6.47A5 5 0 0 1 27.14 29zm-3-10v4.47a3 3 0 0 0 1.72 2.71l1.28.61 1.28-.61A3 3 0 0 0 28 24.47V20z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthCdCreateArchive32;
