'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthCrossReference32 = {
  name: 'WatsonHealthCrossReference32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M11 24h4v2h-4zm-6 0h4v2H5zm18 0h4v2h-4zm-6 0h4v2h-4zm-8-2a4.92 4.92 0 0 1 4-2h6a5.22 5.22 0 0 1 4 2h2.3a6.87 6.87 0 0 0-6.3-4h-6a6.87 6.87 0 0 0-6.3 4zm15 6h2v2h-2zM6 28h2v2H6zm10-12a7 7 0 1 1 7-7 7 7 0 0 1-7 7zm0-12a5 5 0 0 0-5 5 5 5 0 0 0 10 0 5 5 0 0 0-5-5z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthCrossReference32;
