'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthHangingProtocol16 = {
  name: 'WatsonHealthHangingProtocol16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M26.37 20.52L17 15.41v-1.55A4 4 0 1 0 12 10h2a2 2 0 1 1 4 .34A2.08 2.08 0 0 1 15.89 12a.89.89 0 0 0-.89.89v2.52l-9.37 5.11A3.1 3.1 0 0 0 4.25 22a2.83 2.83 0 0 0 2.56 4h18.38a2.83 2.83 0 0 0 2.56-4 3.1 3.1 0 0 0-1.38-1.48zM25.19 24H6.81a.81.81 0 0 1-.81-.81 1 1 0 0 1 .52-.88L16 17.14l9.48 5.17a1 1 0 0 1 .52.88.81.81 0 0 1-.81.81z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthHangingProtocol16;
