'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthLaunchStudy_332 = {
  name: 'WatsonHealthLaunchStudy_332',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('circle', {
      attrs: {
        "cx": "23",
        "cy": "25",
        "r": "1"
      }
    }), createElement('path', {
      attrs: {
        "d": "M26 22v6H6v-6h20m0-2H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zM20.59 4.59L17 8.17V0h-2v8.17l-3.59-3.58L10 6l6 6 6-6-1.41-1.41z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M20.59 10.59L16 15.16l-4.59-4.57L10 12l6 6 6-6-1.41-1.41zM8 24h12v2H8z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthLaunchStudy_332;
