'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthPageScroll24 = {
  name: 'WatsonHealthPageScroll24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M16 28H4a1.89 1.89 0 0 1-2-2V14a1.89 1.89 0 0 1 2-2h12a1.89 1.89 0 0 1 2 2v12a1.89 1.89 0 0 1-2 2zM4 14v12h12V14z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M22 19h-2v-9H10V8h10a1.89 1.89 0 0 1 2 2z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M26 14h-2V6h-8V4h8a1.89 1.89 0 0 1 2 2zm-2 3v2h2.8L22 24.4V22h-2v6h6v-2h-2.8l4.8-5.4V23h2v-6h-6z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthPageScroll24;
