'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthRegionAnalysisVolume24 = {
  name: 'WatsonHealthRegionAnalysisVolume24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M30 23v-2h-2v-2h-2v2h-3v-2h-2v2h-2v2h2v3h-2v2h2v2h2v-2h3v2h2v-2h2v-2h-2v-3zm-4 3h-3v-3h3z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M4.83 20.355A24.953 24.953 0 0 0 15 22.965v-2a22.901 22.901 0 0 1-10.867-3.273A11.979 11.979 0 0 1 4 16a11.985 11.985 0 0 1 .133-1.69 22.928 22.928 0 0 1 23.734 0A11.985 11.985 0 0 1 28 16h2a14 14 0 1 0-14 14v-2a12.01 12.01 0 0 1-11.17-7.645zM16 4a12.01 12.01 0 0 1 11.17 7.646 24.898 24.898 0 0 0-22.34 0A12.01 12.01 0 0 1 16 4z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthRegionAnalysisVolume24;
