'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthRegistration32 = {
  name: 'WatsonHealthRegistration32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M28 25h-8a2.003 2.003 0 0 1-2-2v-3h2v3h8V9h-8v3h-2V9a2.002 2.002 0 0 1 2-2h8a2.002 2.002 0 0 1 2 2v14a2.003 2.003 0 0 1-2 2zM8 15h4v2H8z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M20 15h4v2h-4zm-6 0h4v2h-4zm-2 10H4a2.002 2.002 0 0 1-2-2V9a2.002 2.002 0 0 1 2-2h8a2.002 2.002 0 0 1 2 2v3h-2V9H4v14h8v-3h2v3a2.002 2.002 0 0 1-2 2z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthRegistration32;
