'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthSpineLabel16 = {
  name: 'WatsonHealthSpineLabel16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M3 11v2h5.59l-6.3 6.29 1.42 1.42 6.29-6.3V20h2v-9H3zm23 2h-3v-1h-2v1h-3a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h3v1h2v-1h3a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm-8 4v-2h8v2zm8 6h-3v-1h-2v1h-3a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h3v1h2v-1h3a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm-8 4v-2h8v2zm8-24h-3V2h-2v1h-3a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h3v1h2V9h3a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zm-8 4V5h8v2z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthSpineLabel16;
