'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_WatsonHealthWindowBase16 = {
  name: 'WatsonHealthWindowBase16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M15 2h2v3h-2zm10 11h3v2h-3zM15 23h2v3h-2zM4 13h3v2H4zm2.775-6.812L8.19 4.773l2.122 2.122-1.414 1.414zm14.921.712l2.12-2.122 1.415 1.415-2.121 2.12zm-.005 14.188l1.415-1.414 2.12 2.122-1.413 1.414zm-14.913.725L8.9 19.69l1.414 1.414-2.121 2.122zM4 28h24v2H4zm12-8a6 6 0 1 0-6-6 6 6 0 0 0 6 6zm0-10v8a4 4 0 0 1 0-8z"
      }
    }), children]);
  }
};

module.exports = virtual_WatsonHealthWindowBase16;
