(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Apps16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Apps16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 16 16',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M4 2v2H2V2h2zm1-1H1v4h4V1zm4 1v2H7V2h2zm1-1H6v4h4V1zm4 1v2h-2V2h2zm1-1h-4v4h4V1zM4 7v2H2V7h2zm1-1H1v4h4V6zm4 1v2H7V7h2zm1-1H6v4h4V6zm4 1v2h-2V7h2zm1-1h-4v4h4V6zM4 12v2H2v-2h2zm1-1H1v4h4v-4zm4 1v2H7v-2h2zm1-1H6v4h4v-4zm4 1v2h-2v-2h2zm1-1h-4v4h4v-4z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
