(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Apps20 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _20 = {
    name: 'Apps20',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '20',
        height: '20',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M8 4v4H4V4h4zm2-2H2v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zM8 14v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zM8 24v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8z',
          },
        }),
        children,
      ]);
    },
  };

  return _20;

})));
