(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Arrival24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'Arrival24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M2 28h28v2H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0 1 27 20.62a1.88 1.88 0 0 1-1.37 1.52 2 2 0 0 1-1 0l-18.7-5a1.89 1.89 0 0 1-1.33-2.3l1.75-6.5 1.44.38.61 5.18 6 1.62 2.81-10.29m-1-2.2a1 1 0 0 0-.68.69L13 13.07l-2.81-.75-.5-4.53A1 1 0 0 0 9 7l-3.13-.86a.94.94 0 0 0-.5 0 1 1 0 0 0-.68.68l-2 7.49a3.87 3.87 0 0 0 2.74 4.74l18.71 5A3.87 3.87 0 0 0 29 21a4 4 0 0 0-3-4.42l-4.52-1.21-.95-10.66a1 1 0 0 0-.72-.85L16.73 3a1.06 1.06 0 0 0-.5 0z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
