(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Asleep16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Asleep16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 16 16',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M7.2 2.3c-1 4.4 1.7 8.7 6.1 9.8h.2c-1.1 1.2-2.7 1.8-4.3 1.8H9c-3.4-.1-6-2.9-5.8-6.2 0-2.4 1.6-4.6 4-5.4M8 1c-3.9.6-6.5 4.3-5.9 8.1.6 3.3 3.4 5.8 6.8 5.9h.3c2.3 0 4.4-1.1 5.8-3 .2-.2.1-.6-.1-.7-.1-.1-.2-.1-.3-.1-3.9-.3-6.7-3.8-6.4-7.6.1-.6.2-1.2.4-1.8.1-.3 0-.6-.3-.7C8.1 1 8.1 1 8 1z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
