(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Attachment16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Attachment16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 16 16',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M14.1 9L7 1.9C5.6.6 3.3.7 2 2.1S.7 5.6 1.9 7l1.6 1.6.8-.8-1.6-1.6c-1-.9-1-2.5-.1-3.5s2.5-1 3.5-.1l.1.1 7.1 7.1c1 .9 1 2.5.1 3.5s-2.5 1-3.5.1l-.1-.1-3.3-3.4c-.6-.5-.6-1.4 0-1.9s1.4-.5 1.9 0l1.7 1.7.8-.7-1.8-1.8c-1-.9-2.5-.9-3.5.1-.9.9-.9 2.4 0 3.3L9 14.1c1.4 1.3 3.7 1.2 5-.2s1.3-3.5.1-4.9z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
