(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Attachment20 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _20 = {
    name: 'Attachment20',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '20',
        height: '20',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M27.1 17.9l-13-13a6.51 6.51 0 0 0-9.2 9.2l3 3 1.41-1.41-3-3a4.5 4.5 0 1 1 6.36-6.36l13 13a4.5 4.5 0 1 1-6.36 6.36l-6.13-6.13A2.5 2.5 0 0 1 16.72 16l3.17 3.17 1.41-1.41s-3.22-3.23-3.25-3.24a4.49 4.49 0 0 0-6.34 6.35l6.19 6.23a6.51 6.51 0 0 0 9.2-9.2z',
          },
        }),
        children,
      ]);
    },
  };

  return _20;

})));
