(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Bluetooth16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'Bluetooth16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M16 30a1.06 1.06 0 0 1-.42-.09A1 1 0 0 1 15 29V18.41L8.41 25 7 23.59 14.59 16 7 8.41 8.41 7 15 13.59V3a1 1 0 0 1 .58-.91 1 1 0 0 1 1.07.15l7 6A1 1 0 0 1 24 9a1 1 0 0 1-.29.75L17.41 16l6.3 6.29A1 1 0 0 1 24 23a1 1 0 0 1-.35.72l-7 6A1 1 0 0 1 16 30zm1-11.59v8.42l4.53-3.89zm0-13.24v8.42l4.53-4.53z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
