(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.BuildingInsights_320 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _20 = {
    name: 'BuildingInsights_320',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '20',
        height: '20',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM2 10h5v2H2zm8-8h2v5h-2zM4 5.414L5.414 4 9 7.585 7.585 9z',
          },
        }),
        children,
      ]);
    },
  };

  return _20;

})));
