(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.Bus24 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _24 = {
    name: 'Bus24',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '24',
        height: '24',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: { d: 'M3 8h2v6H3zm24 0h2v6h-2zM10 19h2v2h-2zm10 0h2v2h-2z' },
        }),
        createElement('path', {
          attrs: {
            d:
              'M21 2H11a5 5 0 0 0-5 5v16a2 2 0 0 0 2 2v3h2v-3h12v3h2v-3a2 2 0 0 0 2-2V7a5 5 0 0 0-5-5zm3 6v7H8V8zM11 4h10a3 3 0 0 1 2.82 2H8.18A3 3 0 0 1 11 4zM8 23v-6h16v6z',
          },
        }),
        children,
      ]);
    },
  };

  return _24;

})));
