(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@carbon/icon-helpers')) :
  typeof define === 'function' && define.amd ? define(['@carbon/icon-helpers'], factory) :
  (global.CalculatorCheck16 = factory(global.CarbonIconHelpers));
}(this, (function (iconHelpers) { 'use strict';

  var _16 = {
    name: 'CalculatorCheck16',
    functional: true,
    // We use title as the prop name as it is not a valid attribute for an SVG
    // HTML element
    props: ['title'],
    render(createElement, context) {
      const { children, data, listeners, props } = context;
      const attrs = iconHelpers.getAttributes({
        width: '16',
        height: '16',
        viewBox: '0 0 32 32',
        preserveAspectRatio: 'xMidYMid meet',
        xmlns: 'http://www.w3.org/2000/svg',
        // Special case here, we need to coordinate that we are using title,
        // potentially, to get the right focus attributes
        title: props.title,
        ...data.attrs,
      });
      const svgData = {
        attrs,
        on: listeners,
      };

      if (data.staticClass) {
        svgData.class = {
          [data.staticClass]: true,
        };
      }

      if (data.class) {
        svgData.class[data.class] = true;
      }

      return createElement('svg', svgData, [
        props.title && createElement('title', null, props.title),
        createElement('path', {
          attrs: {
            d:
              'M24 26.59L21.41 24 20 25.41l4 4 7-7L29.59 21 24 26.59zM15 23h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm0-6h14v3H9z',
          },
        }),
        createElement('path', {
          attrs: {
            d:
              'M17 30H6.005A2.007 2.007 0 0 1 4 27.995V3.996A1.998 1.998 0 0 1 5.996 2h20.008A1.998 1.998 0 0 1 28 3.996V18h-2V4H6v24h11z',
          },
        }),
        children,
      ]);
    },
  };

  return _16;

})));
